//********************************************************************************
int ReturnBitValTCPacket80(int BitInArray )
//Returns the BitValue in a multibitarray made of BYTES....sent 0.....79 as a Bit
{
 if ( BitInArray == -1 ) return 0;
 int ByteCount = ( BitInArray / 8 );                                // EG Bits 16..23 /8 = Byte 2.....24..31 = BYTE 3
 int BitInByte =  (BitInArray - ( (BitInArray / 8) * 8 ) );         // EG Bit 18/8 = 2 * 8 = 16....18-16 = 2 = 3rd Bit in Byte 2
 int RetVal = bitRead( TimeCodePacket[ByteCount], BitInByte );
 
 return RetVal;
}




//********************************************************************************
int ReturnBitValTCPacket160(long BitInArray )      
//Returns the BitValue in a multibitarray made of BYTES....sent 0.....159 as a Bit
{
 if ( BitInArray == -1 ) return 0;
 long ByteCount = ( BitInArray / 16 );                                // EG Bits 16..23 /8 = Byte 2.....24..31 = BYTE 3
 long BitInByte =  ((BitInArray %16) /2 );                // EG Bit 18/8 = 2 * 8 = 16....18-16 = 2 = 3rd Bit in Byte 2
 long RetVal = bitRead( TimeCodePacket[ByteCount], BitInByte );
 
 return RetVal;
}





//********************************************************************************
void CheckBitFiftyNine()
{
  int NumberOfZeros = 0;
  int NumberOfOnes = 0;
  bitWrite ( TimeCodePacket[PhaseByte],7,0);            // Reset the Parity byte to default 0
  
  for ( int i = 0; i< 64; i++)
      {
        if ( ReturnBitValTCPacket80( i ) == 0 )   NumberOfZeros ++;
      }
      NumberOfZeros ++;            // Save a couple of cycles by NOY counting the three Zeros in Bytes 8 & 9
   
    if ( (   NumberOfZeros % 2 )  > 0 )  bitWrite ( TimeCodePacket[PhaseByte],7,1);                                                 
}



void TCPacketUpdate()
{

 Secs  ( UpdateFromHMS );
 Mins  ( UpdateFromHMS );
 Hours ( UpdateFromHMS );
}







/*



//********************************************************************************
void PrintTheTime()
{
 int TimeArray[] = { Hours(ReportStatus),Mins(ReportStatus) , Secs(ReportStatus) , Frames(ReportStatus) };
 for ( int i = 0;  i < 4; i++ )
     {
      if ( TimeArray[i] < 10 ) Serial.print("0");
      Serial.print( TimeArray[i] );
      if ( i != 3 ) Serial.print(" : ");
      
     }
 Serial.println();    
      
}


//********************************************************************************
void PrintTCBytes()
{
 for ( int ByteCount = 0; ByteCount < 10; ByteCount++)
     {
       for ( int BitCount = 0; BitCount < 8; BitCount++)
           {
            if ( bitRead( TimeCodePacket[ByteCount],BitCount )  == 1 ) Serial.print("1");
            else Serial.print(".");
           }
      Serial.print(" ");     
     } 
 Serial.println();           
}

*/


