#include "init.h"

void setup() 
{
  Serial.begin(9600);
  Serial.println("Starting "); 
  pinMode( SmpteOutputPinPLUS, OUTPUT );              // Pin 10 + Pin 11 are the ' Balanced Outputs '
  pinMode( SmpteOutputPinNEG,  OUTPUT );
  pinMode( TimingOutput,       OUTPUT );
  
  InitialiseHMSF();                 // Create Frame 0 
}


//********************************************************************************
//********************************************************************************

void loop()
{
 WriteLTCEdge();
    
}




void WriteLTCEdge()

{
 long         CurrentTimeuS =  micros();
 static long  TimeOfNextElecEdge =  CurrentTimeuS - 1;
 static long  FrameStartTime = CurrentTimeuS;
 static long  CurrBit = -1;
 long         TimeIsUp = CurrentTimeuS - TimeOfNextElecEdge;

 if (TimeIsUp > 0 )  
 {

  WriteBalancedOutput();
 
  CurrBit++;
                                             // Read the Serial Data
  
  if ( CurrBit >= 160 )                                  // We have come to the end of the frame so update Counters and Timers
    { 
     CurrBit = 0; 
     FrameStartTime = CurrentTimeuS; 
     //WriteFrameMarkerPulse();
    }
 
  if ( CurrBit == 128 ) Frames( IncrementNow);          // Claculate all the bits in Bit 8

  if ( CurrBit == 130 )  CheckBitFiftyNine();  // WriteFrameMarkerPulse(); }

 
  
  // If we are in the First Half of a bit and the Value is zero, we have 500uS
  // to do other stuff.. We must Advance the Curr bit couter so it is correct for the following bit

  if   ( ( CurrBit % 2 == 0 ) && ( ReturnBitValTCPacket160( CurrBit ) == 0 ) )
       { 
         TimeOfNextElecEdge = TIMES[CurrBit + 1] + FrameStartTime;     // Or (((CurrBit/2 )+1)*BitWidth) + FrameStartTime; works too
         if ( ReadGPGGA() == true ) 
            { 
              TCPacketUpdate() ;                 // You have 500 us so do something with this time
              CheckBitFiftyNine();               // Ensure the new packet is Phase correct
            }
         CurrBit++;
        }
  
  else TimeOfNextElecEdge = TIMES[CurrBit]       + FrameStartTime;
 }

}


















































