//********************************************************************************
void InitialiseHMSF()
{
  Frames ( UpdateFromHMS );      // Send a false to initialise variables and update TimeCodePacket[]
  Secs   ( UpdateFromHMS );
  Mins   ( UpdateFromHMS );
  Hours  ( UpdateFromHMS );
}


//********************************************************************************
int Hours( boolean Increment )
{
  static int Hours = HoursStart;                           // Default set to non zero for test

  if ( Increment == true )
     {
      Hours++;
      if ( Hours >= 24 ) 
       {
        Hours = 0;
       }  
     }
     
  else Hours = HoursOffset + HMS[1] + ( HMS[0] * 10 ) ;                   // Update from HMS
  
  TimeCodePacket[6] = BCDByteLower[ Hours];
  TimeCodePacket[7] = BCDByteUpper[ Hours ]; 
  TimeCodePacket[8] = PacketEight;
  TimeCodePacket[9] = PacketNine;
  
  
  return Hours;   
}

//********************************************************************************
int Mins( boolean Increment )
{
  static int Mins = MinsStart;                           // Default set to non zero for test

  if ( Increment == true )
     {
      Mins++;
      if ( Mins >= 60 ) 
       {
        Mins = 0;
        Hours ( IncrementNow);
       }  
     }
  else Mins = HMS[3] + ( HMS[2] * 10 );
  TimeCodePacket[4] = BCDByteLower[ Mins];
  TimeCodePacket[5] = BCDByteUpper[ Mins ]; 
  
  return Mins;   
}

//********************************************************************************
int Secs( boolean Increment )
{
  static int Secs = SecsStart;

  if ( Increment == true )
     {
      Secs++; 
      //PrintTheTime();    
      if ( Secs >= 60 ) 
       {
        Secs = 0;
        Mins( IncrementNow );
       }  
     }
  else Secs = HMS[5] + ( HMS[4] * 10 );
  TimeCodePacket[2] = BCDByteLower[ Secs];
  TimeCodePacket[3] = BCDByteUpper[ Secs ]; 
  
  return Secs;   
}

//********************************************************************************
int Frames( boolean Increment )
{
  static int Frames = 0;

  if ( Increment == true )
     {
      Frames++;
      if ( Frames >= 25 )            // Fixed Frame Rate of 25 FPS
       {
        Frames = 0;
        Secs( IncrementNow );
       }
     }
     
  TimeCodePacket[0] = BCDByteLower[ Frames ];
  TimeCodePacket[1] = BCDByteUpper[ Frames ]; 
  
  
  return Frames;   
}



//********************************************************************************
void TransTimeArrayUpdate(int Something )
{
  
}


